/**************************************************************************
 * FILE:    @(#)bmp.c	1.5 04/09/08	
 * DESCRIPTION:
 *  Bitmaps of characters for VGA.  	
 *************************************************************************/
#if defined(DEMO)
#include "demo.h"
#else
#include "tetris.h"
#endif

#if ( defined(TETRIS) && defined(NEXAR) )

#if (TETRISOUT != SERIAL0 || TETRISOUT != SERIAL1)

  unsigned char bios_char_00[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_01[] = {
    8,
    8,
    0x7E, 0x81, 0xA5, 0x81,
    0xBD, 0x99, 0x81, 0x7E
    };

  unsigned char bios_char_02[] = {
    8,
    8,
    0x7E, 0xFF, 0xDB, 0xFF,
    0xC3, 0xE7, 0xFF, 0x7E
    };

  unsigned char bios_char_03[] = {
    8,
    8,
    0x6C, 0xFE, 0xFE, 0xFE,
    0x7C, 0x38, 0x10, 0x00
    };

  unsigned char bios_char_04[] = {
    8,
    8,
    0x10, 0x38, 0x7C, 0xFE,
    0x7C, 0x38, 0x10, 0x00
    };

  unsigned char bios_char_05[] = {
    8,
    8,
    0x38, 0x7C, 0x38, 0xFE,
    0xFE, 0x7C, 0x38, 0x7C
    };

  unsigned char bios_char_06[] = {
    8,
    8,
    0x10, 0x10, 0x38, 0x7C,
    0xFE, 0x7C, 0x38, 0x7C
    };

  unsigned char bios_char_07[] = {
    8,
    8,
    0x00, 0x00, 0x18, 0x3C,
    0x3C, 0x18, 0x00, 0x00
    };

  unsigned char bios_char_08[] = {
    8,
    8,
    0xFF, 0xFF, 0xE7, 0xC3,
    0xC3, 0xE7, 0xFF, 0xFF
    };

  unsigned char bios_char_09[] = {
    8,
    8,
    0x00, 0x3C, 0x66, 0x42,
    0x42, 0x66, 0x3C, 0x00
    };

  unsigned char bios_char_0A[] = {
    8,
    8,
    0xFF, 0xC3, 0x99, 0xBD,
    0xBD, 0x99, 0xC3, 0xFF
    };

  unsigned char bios_char_0B[] = {
    8,
    8,
    0x0F, 0x07, 0x0F, 0x7D,
    0xCC, 0xCC, 0xCC, 0x78
    };

  unsigned char bios_char_0C[] = {
    8,
    8,
    0x3C, 0x66, 0x66, 0x66,
    0x3C, 0x18, 0x7E, 0x18
    };

  unsigned char bios_char_0D[] = {
    8,
    8,
    0x3F, 0x33, 0x3F, 0x30,
    0x30, 0x70, 0xF0, 0xE0
    };

  unsigned char bios_char_0E[] = {
    8,
    8,
    0x7F, 0x63, 0x7F, 0x63,
    0x63, 0x67, 0xE6, 0xC0
    };

  unsigned char bios_char_0F[] = {
    8,
    8,
    0x99, 0x5A, 0x3C, 0xE7,
    0xE7, 0x3C, 0x5A, 0x99
    };

  unsigned char bios_char_10[] = {
    8,
    8,
    0x80, 0xE0, 0xF8, 0xFE,
    0xF8, 0xE0, 0x80, 0x00
    };

  unsigned char bios_char_11[] = {
    8,
    8,
    0x02, 0x0E, 0x3E, 0xFE,
    0x3E, 0x0E, 0x02, 0x00
    };

  unsigned char bios_char_12[] = {
    8,
    8,
    0x18, 0x3C, 0x7E, 0x18,
    0x18, 0x7E, 0x3C, 0x18
    };

  unsigned char bios_char_13[] = {
    8,
    8,
    0x66, 0x66, 0x66, 0x66,
    0x66, 0x00, 0x66, 0x00
    };

  unsigned char bios_char_14[] = {
    8,
    8,
    0x7F, 0xDB, 0xDB, 0x7B,
    0x1B, 0x1B, 0x1B, 0x00
    };

  unsigned char bios_char_15[] = {
    8,
    8,
    0x3E, 0x63, 0x38, 0x6C,
    0x6C, 0x38, 0xCC, 0x78
    };

  unsigned char bios_char_16[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x7E, 0x7E, 0x7E, 0x00
    };

  unsigned char bios_char_17[] = {
    8,
    8,
    0x18, 0x3C, 0x7E, 0x18,
    0x7E, 0x3C, 0x18, 0xFF
    };

  unsigned char bios_char_18[] = {
    8,
    8,
    0x18, 0x3C, 0x7E, 0x18,
    0x18, 0x18, 0x18, 0x00
    };

  unsigned char bios_char_19[] = {
    8,
    8,
    0x18, 0x18, 0x18, 0x18,
    0x7E, 0x3C, 0x18, 0x00
    };

  unsigned char bios_char_1A[] = {
    8,
    8,
    0x00, 0x18, 0x0C, 0xFE,
    0x0C, 0x18, 0x00, 0x00
    };

  unsigned char bios_char_1B[] = {
    8,
    8,
    0x00, 0x30, 0x60, 0xFE,
    0x60, 0x30, 0x00, 0x00
    };

  unsigned char bios_char_1C[] = {
    8,
    8,
    0x00, 0x00, 0xC0, 0xC0,
    0xC0, 0xFE, 0x00, 0x00
    };

  unsigned char bios_char_1D[] = {
    8,
    8,
    0x00, 0x24, 0x66, 0xFF,
    0x66, 0x24, 0x00, 0x00
    };

  unsigned char bios_char_1E[] = {
    8,
    8,
    0x00, 0x18, 0x3C, 0x7E,
    0xFF, 0xFF, 0x00, 0x00
    };

  unsigned char bios_char_1F[] = {
    8,
    8,
    0x00, 0xFF, 0xFF, 0x7E,
    0x3C, 0x18, 0x00, 0x00
    };

  unsigned char bios_char_20[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_21[] = {
    8,
    8,
    0x30, 0x78, 0x78, 0x30,
    0x30, 0x00, 0x30, 0x00
    };

  unsigned char bios_char_22[] = {
    8,
    8,
    0x6C, 0x6C, 0x6C, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_23[] = {
    8,
    8,
    0x6C, 0x6C, 0xFE, 0x6C,
    0xFE, 0x6C, 0x6C, 0x00
    };

  unsigned char bios_char_24[] = {
    8,
    8,
    0x30, 0x7C, 0xC0, 0x78,
    0x0C, 0xF8, 0x30, 0x00
    };

  unsigned char bios_char_25[] = {
    8,
    8,
    0x00, 0xC6, 0xCC, 0x18,
    0x30, 0x66, 0xC6, 0x00
    };

  unsigned char bios_char_26[] = {
    8,
    8,
    0x38, 0x6C, 0x38, 0x76,
    0xDC, 0xCC, 0x76, 0x00
    };

  unsigned char bios_char_27[] = {
    8,
    8,
    0x60, 0x60, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_28[] = {
    8,
    8,
    0x18, 0x30, 0x60, 0x60,
    0x60, 0x30, 0x18, 0x00
    };

  unsigned char bios_char_29[] = {
    8,
    8,
    0x60, 0x30, 0x18, 0x18,
    0x18, 0x30, 0x60, 0x00
    };

  unsigned char bios_char_2A[] = {
    8,
    8,
    0x00, 0x66, 0x3C, 0xFF,
    0x3C, 0x66, 0x00, 0x00
    };

  unsigned char bios_char_2B[] = {
    8,
    8,
    0x00, 0x30, 0x30, 0xFC,
    0x30, 0x30, 0x00, 0x00
    };

  unsigned char bios_char_2C[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x30, 0x30, 0x60
    };

  unsigned char bios_char_2D[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0xFC,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_2E[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x30, 0x30, 0x00
    };

  unsigned char bios_char_2F[] = {
    8,
    8,
    0x06, 0x0C, 0x18, 0x30,
    0x60, 0xC0, 0x80, 0x00
    };

  unsigned char bios_char_30[] = {
    8,
    8,
    0x7C, 0xC6, 0xCE, 0xDE,
    0xF6, 0xE6, 0x7C, 0x00
    };

  unsigned char bios_char_31[] = {
    8,
    8,
    0x30, 0x70, 0x30, 0x30,
    0x30, 0x30, 0xFC, 0x00
    };

  unsigned char bios_char_32[] = {
    8,
    8,
    0x78, 0xCC, 0x0C, 0x38,
    0x60, 0xCC, 0xFC, 0x00
    };

  unsigned char bios_char_33[] = {
    8,
    8,
    0x78, 0xCC, 0x0C, 0x38,
    0x0C, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_34[] = {
    8,
    8,
    0x1C, 0x3C, 0x6C, 0xCC,
    0xFE, 0x0C, 0x1E, 0x00
    };

  unsigned char bios_char_35[] = {
    8,
    8,
    0xFC, 0xC0, 0xF8, 0x0C,
    0x0C, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_36[] = {
    8,
    8,
    0x38, 0x60, 0xC0, 0xF8,
    0xCC, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_37[] = {
    8,
    8,
    0xFC, 0xCC, 0x0C, 0x18,
    0x30, 0x30, 0x30, 0x00
    };

  unsigned char bios_char_38[] = {
    8,
    8,
    0x78, 0xCC, 0xCC, 0x78,
    0xCC, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_39[] = {
    8,
    8,
    0x78, 0xCC, 0xCC, 0x7C,
    0x0C, 0x18, 0x70, 0x00
    };

  unsigned char bios_char_3A[] = {
    8,
    8,
    0x00, 0x30, 0x30, 0x00,
    0x00, 0x30, 0x30, 0x00
    };

  unsigned char bios_char_3B[] = {
    8,
    8,
    0x00, 0x30, 0x30, 0x00,
    0x00, 0x30, 0x30, 0x60
    };

  unsigned char bios_char_3C[] = {
    8,
    8,
    0x18, 0x30, 0x60, 0xC0,
    0x60, 0x30, 0x18, 0x00
    };

  unsigned char bios_char_3D[] = {
    8,
    8,
    0x00, 0x00, 0xFC, 0x00,
    0x00, 0xFC, 0x00, 0x00
    };

  unsigned char bios_char_3E[] = {
    8,
    8,
    0x60, 0x30, 0x18, 0x0C,
    0x18, 0x30, 0x60, 0x00
    };

  unsigned char bios_char_3F[] = {
    8,
    8,
    0x78, 0xCC, 0x0C, 0x18,
    0x30, 0x00, 0x30, 0x00
    };

  unsigned char bios_char_40[] = {
    8,
    8,
    0x7C, 0xC6, 0xDE, 0xDE,
    0xDE, 0xC0, 0x78, 0x00
    };

  unsigned char bios_char_41[] = {
    8,
    8,
    0x30, 0x78, 0xCC, 0xCC,
    0xFC, 0xCC, 0xCC, 0x00
    };

  unsigned char bios_char_42[] = {
    8,
    8,
    0xFC, 0x66, 0x66, 0x7C,
    0x66, 0x66, 0xFC, 0x00
    };

  unsigned char bios_char_43[] = {
    8,
    8,
    0x3C, 0x66, 0xC0, 0xC0,
    0xC0, 0x66, 0x3C, 0x00
    };

  unsigned char bios_char_44[] = {
    8,
    8,
    0xF8, 0x6C, 0x66, 0x66,
    0x66, 0x6C, 0xF8, 0x00
    };

  unsigned char bios_char_45[] = {
    8,
    8,
    0xFE, 0x62, 0x68, 0x78,
    0x68, 0x62, 0xFE, 0x00
    };

  unsigned char bios_char_46[] = {
    8,
    8,
    0xFE, 0x62, 0x68, 0x78,
    0x68, 0x60, 0xF0, 0x00
    };

  unsigned char bios_char_47[] = {
    8,
    8,
    0x3C, 0x66, 0xC0, 0xC0,
    0xCE, 0x66, 0x3E, 0x00
    };

  unsigned char bios_char_48[] = {
    8,
    8,
    0xCC, 0xCC, 0xCC, 0xFC,
    0xCC, 0xCC, 0xCC, 0x00
    };

  unsigned char bios_char_49[] = {
    8,
    8,
    0x78, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x78, 0x00
    };

  unsigned char bios_char_4A[] = {
    8,
    8,
    0x1E, 0x0C, 0x0C, 0x0C,
    0xCC, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_4B[] = {
    8,
    8,
    0xE6, 0x66, 0x6C, 0x78,
    0x6C, 0x66, 0xE6, 0x00
    };

  unsigned char bios_char_4C[] = {
    8,
    8,
    0xF0, 0x60, 0x60, 0x60,
    0x62, 0x66, 0xFE, 0x00
    };

  unsigned char bios_char_4D[] = {
    8,
    8,
    0xC6, 0xEE, 0xFE, 0xFE,
    0xD6, 0xC6, 0xC6, 0x00
    };

  unsigned char bios_char_4E[] = {
    8,
    8,
    0xC6, 0xE6, 0xF6, 0xDE,
    0xCE, 0xC6, 0xC6, 0x00
    };

  unsigned char bios_char_4F[] = {
    8,
    8,
    0x38, 0x6C, 0xC6, 0xC6,
    0xC6, 0x6C, 0x38, 0x00
    };

  unsigned char bios_char_50[] = {
    8,
    8,
    0xFC, 0x66, 0x66, 0x7C,
    0x60, 0x60, 0xF0, 0x00
    };

  unsigned char bios_char_51[] = {
    8,
    8,
    0x78, 0xCC, 0xCC, 0xCC,
    0xDC, 0x78, 0x1C, 0x00
    };

  unsigned char bios_char_52[] = {
    8,
    8,
    0xFC, 0x66, 0x66, 0x7C,
    0x6C, 0x66, 0xE6, 0x00
    };

  unsigned char bios_char_53[] = {
    8,
    8,
    0x78, 0xCC, 0xE0, 0x70,
    0x1C, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_54[] = {
    8,
    8,
    0xFC, 0xB4, 0x30, 0x30,
    0x30, 0x30, 0x78, 0x00
    };

  unsigned char bios_char_55[] = {
    8,
    8,
    0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0xCC, 0xFC, 0x00
    };

  unsigned char bios_char_56[] = {
    8,
    8,
    0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0x78, 0x30, 0x00
    };

  unsigned char bios_char_57[] = {
    8,
    8,
    0xC6, 0xC6, 0xC6, 0xD6,
    0xFE, 0xEE, 0xC6, 0x00
    };

  unsigned char bios_char_58[] = {
    8,
    8,
    0xC6, 0xC6, 0x6C, 0x38,
    0x38, 0x6C, 0xC6, 0x00
    };

  unsigned char bios_char_59[] = {
    8,
    8,
    0xCC, 0xCC, 0xCC, 0x78,
    0x30, 0x30, 0x78, 0x00
    };

  unsigned char bios_char_5A[] = {
    8,
    8,
    0xFE, 0xC6, 0x8C, 0x18,
    0x32, 0x66, 0xFE, 0x00
    };

  unsigned char bios_char_5B[] = {
    8,
    8,
    0x78, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x78, 0x00
    };

  unsigned char bios_char_5C[] = {
    8,
    8,
    0xC0, 0x60, 0x30, 0x18,
    0x0C, 0x06, 0x02, 0x00
    };

  unsigned char bios_char_5D[] = {
    8,
    8,
    0x78, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x78, 0x00
    };

  unsigned char bios_char_5E[] = {
    8,
    8,
    0x10, 0x38, 0x6C, 0xC6,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_5F[] = {
    8,
    8,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xFF
    };

  unsigned char bios_char_60[] = {
    8,
    8,
    0x30, 0x30, 0x18, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_61[] = {
    8,
    8,
    0x00, 0x00, 0x78, 0x0C,
    0x7C, 0xCC, 0x76, 0x00
    };

  unsigned char bios_char_62[] = {
    8,
    8,
    0xE0, 0x60, 0x60, 0x7C,
    0x66, 0x66, 0xDC, 0x00
    };

  unsigned char bios_char_63[] = {
    8,
    8,
    0x00, 0x00, 0x78, 0xCC,
    0xC0, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_64[] = {
    8,
    8,
    0x1C, 0x0C, 0x0C, 0x7C,
    0xCC, 0xCC, 0x76, 0x00
    };

  unsigned char bios_char_65[] = {
    8,
    8,
    0x00, 0x00, 0x78, 0xCC,
    0xFC, 0xC0, 0x78, 0x00
    };

  unsigned char bios_char_66[] = {
    8,
    8,
    0x38, 0x6C, 0x60, 0xF0,
    0x60, 0x60, 0xF0, 0x00
    };

  unsigned char bios_char_67[] = {
    8,
    8,
    0x00, 0x00, 0x76, 0xCC,
    0xCC, 0x7C, 0x0C, 0xF8
    };

  unsigned char bios_char_68[] = {
    8,
    8,
    0xE0, 0x60, 0x6C, 0x76,
    0x66, 0x66, 0xE6, 0x00
    };

  unsigned char bios_char_69[] = {
    8,
    8,
    0x30, 0x00, 0x70, 0x30,
    0x30, 0x30, 0x78, 0x00
    };

  unsigned char bios_char_6A[] = {
    8,
    8,
    0x0C, 0x00, 0x0C, 0x0C,
    0x0C, 0xCC, 0xCC, 0x78
    };

  unsigned char bios_char_6B[] = {
    8,
    8,
    0xE0, 0x60, 0x66, 0x6C,
    0x78, 0x6C, 0xE6, 0x00
    };

  unsigned char bios_char_6C[] = {
    8,
    8,
    0x70, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x78, 0x00
    };

  unsigned char bios_char_6D[] = {
    8,
    8,
    0x00, 0x00, 0xCC, 0xFE,
    0xFE, 0xD6, 0xC6, 0x00
    };

  unsigned char bios_char_6E[] = {
    8,
    8,
    0x00, 0x00, 0xF8, 0xCC,
    0xCC, 0xCC, 0xCC, 0x00
    };

  unsigned char bios_char_6F[] = {
    8,
    8,
    0x00, 0x00, 0x78, 0xCC,
    0xCC, 0xCC, 0x78, 0x00
    };

  unsigned char bios_char_70[] = {
    8,
    8,
    0x00, 0x00, 0xDC, 0x66,
    0x66, 0x7C, 0x60, 0xF0
    };

  unsigned char bios_char_71[] = {
    8,
    8,
    0x00, 0x00, 0x76, 0xCC,
    0xCC, 0x7C, 0x0C, 0x1E
    };

  unsigned char bios_char_72[] = {
    8,
    8,
    0x00, 0x00, 0xDC, 0x76,
    0x66, 0x60, 0xF0, 0x00
    };

  unsigned char bios_char_73[] = {
    8,
    8,
    0x00, 0x00, 0x7C, 0xC0,
    0x78, 0x0C, 0xF8, 0x00
    };

  unsigned char bios_char_74[] = {
    8,
    8,
    0x10, 0x30, 0x7C, 0x30,
    0x30, 0x34, 0x18, 0x00
    };

  unsigned char bios_char_75[] = {
    8,
    8,
    0x00, 0x00, 0xCC, 0xCC,
    0xCC, 0xCC, 0x76, 0x00
    };

  unsigned char bios_char_76[] = {
    8,
    8,
    0x00, 0x00, 0xCC, 0xCC,
    0xCC, 0x78, 0x30, 0x00
    };

  unsigned char bios_char_77[] = {
    8,
    8,
    0x00, 0x00, 0xC6, 0xD6,
    0xFE, 0xFE, 0x6C, 0x00
    };

  unsigned char bios_char_78[] = {
    8,
    8,
    0x00, 0x00, 0xC6, 0x6C,
    0x38, 0x6C, 0xC6, 0x00
    };

  unsigned char bios_char_79[] = {
    8,
    8,
    0x00, 0x00, 0xCC, 0xCC,
    0xCC, 0x7C, 0x0C, 0xF8
    };

  unsigned char bios_char_7A[] = {
    8,
    8,
    0x00, 0x00, 0xFC, 0x98,
    0x30, 0x64, 0xFC, 0x00
    };

  unsigned char bios_char_7B[] = {
    8,
    8,
    0x1C, 0x30, 0x30, 0xE0,
    0x30, 0x30, 0x1C, 0x00
    };

  unsigned char bios_char_7C[] = {
    8,
    8,
    0x18, 0x18, 0x18, 0x00,
    0x18, 0x18, 0x18, 0x00
    };

  unsigned char bios_char_7D[] = {
    8,
    8,
    0xE0, 0x30, 0x30, 0x1C,
    0x30, 0x30, 0xE0, 0x00
    };

  unsigned char bios_char_7E[] = {
    8,
    8,
    0x76, 0xDC, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
    };

  unsigned char bios_char_7F[] = {
    8,
    8,
    0x00, 0x10, 0x38, 0x6C,
    0xC6, 0xC6, 0xFE, 0x00
    };


unsigned char   *   bios_set[] = {
    bios_char_00,
    bios_char_01,
    bios_char_02,
    bios_char_03,
    bios_char_04,
    bios_char_05,
    bios_char_06,
    bios_char_07,
    bios_char_08,
    bios_char_09,
    bios_char_0A,
    bios_char_0B,
    bios_char_0C,
    bios_char_0D,
    bios_char_0E,
    bios_char_0F,
    bios_char_10,
    bios_char_11,
    bios_char_12,
    bios_char_13,
    bios_char_14,
    bios_char_15,
    bios_char_16,
    bios_char_17,
    bios_char_18,
    bios_char_19,
    bios_char_1A,
    bios_char_1B,
    bios_char_1C,
    bios_char_1D,
    bios_char_1E,
    bios_char_1F,
    bios_char_20,
    bios_char_21,
    bios_char_22,
    bios_char_23,
    bios_char_24,
    bios_char_25,
    bios_char_26,
    bios_char_27,
    bios_char_28,
    bios_char_29,
    bios_char_2A,
    bios_char_2B,
    bios_char_2C,
    bios_char_2D,
    bios_char_2E,
    bios_char_2F,
    bios_char_30,
    bios_char_31,
    bios_char_32,
    bios_char_33,
    bios_char_34,
    bios_char_35,
    bios_char_36,
    bios_char_37,
    bios_char_38,
    bios_char_39,
    bios_char_3A,
    bios_char_3B,
    bios_char_3C,
    bios_char_3D,
    bios_char_3E,
    bios_char_3F,
    bios_char_40,
    bios_char_41,
    bios_char_42,
    bios_char_43,
    bios_char_44,
    bios_char_45,
    bios_char_46,
    bios_char_47,
    bios_char_48,
    bios_char_49,
    bios_char_4A,
    bios_char_4B,
    bios_char_4C,
    bios_char_4D,
    bios_char_4E,
    bios_char_4F,
    bios_char_50,
    bios_char_51,
    bios_char_52,
    bios_char_53,
    bios_char_54,
    bios_char_55,
    bios_char_56,
    bios_char_57,
    bios_char_58,
    bios_char_59,
    bios_char_5A,
    bios_char_5B,
    bios_char_5C,
    bios_char_5D,
    bios_char_5E,
    bios_char_5F,
    bios_char_60,
    bios_char_61,
    bios_char_62,
    bios_char_63,
    bios_char_64,
    bios_char_65,
    bios_char_66,
    bios_char_67,
    bios_char_68,
    bios_char_69,
    bios_char_6A,
    bios_char_6B,
    bios_char_6C,
    bios_char_6D,
    bios_char_6E,
    bios_char_6F,
    bios_char_70,
    bios_char_71,
    bios_char_72,
    bios_char_73,
    bios_char_74,
    bios_char_75,
    bios_char_76,
    bios_char_77,
    bios_char_78,
    bios_char_79,
    bios_char_7A,
    bios_char_7B,
    bios_char_7C,
    bios_char_7D,
    bios_char_7E,
    bios_char_7F,
    };


  unsigned char *bios_font( const char c )
{
      unsigned char *ret_val = 0;

    if ( c <= 0x7F )
    {
        ret_val = bios_set[c];
    }
    else
    {
        ret_val = 0;
    }

    return ret_val;
}


/* bitmap, 16 color image, 4 bits per pixel */
  unsigned char bmp_altium16[] = {
    /* width in pixels */ 160,
    /* height in pixels */ 69,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0xf8, 0x84, 0x48, 0x88, 0x88, 0x88, 0x44, 0x88, 0x88, 0x88, 0x84, 0x44, 0x88, 0x88, 0x88, 0x84, 0x44, 0x88, 0x88, 0x88, 0x44, 0x8f, 0xff, 0xff, 0x84, 0x44, 0x8f, 0xff, 0xff, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xf8, 0x4f, 0xff, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x84, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf8, 0x88, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0xff, 0xff, 0xff, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x88, 0x8f, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x48, 0xff, 0xff, 0xff, 0x44, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xff, 0x84, 0x8f, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8f, 0xff, 0xff, 0xff, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x84, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x84, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x48, 0xff, 0xff, 0xff, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x8f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0x84, 0x44, 0x8f, 0xff, 0xff, 0xff, 0xf4, 0x4f, 0xff, 0xff, 0xf8, 0x44, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xff, 0xff, 0xff, 0x84, 0x44, 0x44, 0x48, 0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0x84, 0x44, 0x48, 0xff, 0xff, 0xff, 0x84, 0x4f, 0xff, 0xff, 0xf4, 0x44, 0x44, 0xff, 0xff, 0xff, 0x84, 0x8f, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0xff, 0x84, 0x44, 0xff, 0xff, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00, 0x00,
    0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

#endif
#endif




